// Copyright (c) 2005 Broad Institute of MIT and Harvard
//
// FlowRead.cc


#include "454/flowdata/FlowRead.h"

#include "454/flowdata/FlowDataBroker.h"


String
FlowRead::GetName() const
{
  return GetMgrPtr()->GetName( GetId() );
}


const FlowOrder &
FlowRead::GetFlowOrder() const
{
  return GetMgrPtr()->GetFlowOrder( GetId() );
}


const FlowVector &
FlowRead::GetFlowVector() const
{
  return GetMgrPtr()->GetFlowVector( GetId() );
}


int
FlowRead::GetLength() const
{
  return GetMgrPtr()->GetLength( GetId() );
}


String ToString(const FlowRead &r, bool includeName,
		bool includeXpos, bool includeYpos,
		bool includeFloats, bool includeIntegers, bool trimmed)
{
  String result;
  String name = r.GetName();
  if (includeName) {
    result += name.SafeBefore("_");
    result += " ";
  }
  if (includeXpos) {
    result += name.SafeAfter("_").SafeBefore("_");
    result += " ";
  }
  if (includeYpos) {
    result += name.SafeAfter("_").SafeAfter("_");
    result += " ";
  }
  const FlowVector & fvec = r.GetFlowVector();
  const int length = (trimmed ? fvec.isize() : fvec.untrimmedSize());
  if (includeFloats) {
    for (int j=0; j != length; ++j) {
      result += ToString(fvec.GetDouble(j), 2);
      result += " ";
    }
  }
  if (includeIntegers) {
    for (int j=0; j != length; ++j) {
      result += ToString(static_cast<unsigned int>(fvec.Get(j)));
      result += " ";
    }
  }

  return result;
}


// In the long run...
//
// basevector
// FlowRead::Basecall( threshold-params ) const
// {
//   return GetMgrPtr()->Basecall( GetId() );
// }

