// Copyright (c) 2005 Broad Institute of MIT and Harvard
//
// FlowOrder.cc


#include "454/flowdata/FlowOrder.h"
#include <sstream>


FlowOrder::FlowOrder( const vec<char> & cycle_list )
{
  const int num_flows_in_cycle = cycle_list.size();
  mCycleString.resize( num_flows_in_cycle );
  for (int i = 0; i < num_flows_in_cycle; i++)
    {
      mCycleString[i] = cycle_list[i];
    }
  mCycleString.ToUpper();
}

FlowOrder::FlowOrder( const String & cycle_list )
{
  if (cycle_list.Contains("\n"))
    fromString(cycle_list); 
  else {
    mCycleString = cycle_list;
    mCycleString.ToUpper();
  }
}

void
FlowOrder::MarkAsP( const int index )
{
  mPlist.push_back( index );
  UniqueSort( mPlist );
}



char
FlowOrder::operator [] ( const int index ) const
{
  ForceAssertGt( mCycleString.size(), 0 );

  int adjusted_index = index;
  vec<int>::const_iterator mPlistIter;
  for ( mPlistIter = mPlist.begin();
	mPlistIter != mPlist.end();
	++mPlistIter )
    {
      if ( *mPlistIter == index )
	return 'P';

      if ( *mPlistIter < index )
	adjusted_index--;
    }

  return mCycleString[ adjusted_index % mCycleString.size() ];
}

String FlowOrder::asString() const
{
  ostringstream outstrm;
  outstrm << mCycleString << "\n";
  outstrm << 0 << "\n"; // obsolete numKeyFlows left in format for compatibility
  outstrm << mPlist; // use vec's << operator
  return outstrm.str();
}

void FlowOrder::fromString(const String &in)
{
  // forward to operator >>
  istringstream instr(in);
  instr >> (*this);
}

ostream &
operator << ( ostream & outstrm, const FlowOrder & floworder )
{
  // forward to asString() member
  outstrm << floworder.asString();
  return outstrm;
}

istream &
operator >> ( istream & instrm, FlowOrder & floworder )
{
  getline( instrm, floworder.mCycleString);
  floworder.mCycleString.ToUpper();

  String junk;
  getline( instrm, junk ); // obsolete numKeyFlows left in format for compatibility

  instrm >> floworder.mPlist; // read vec
  
  return instrm;
}
