// Copyright (c) 2005 Broad Institute of MIT and Harvard
//
// FeudalPlusDataManager.cc


#include "454/flowdata/FeudalPlusDataManager.h"


template <class MasterVecT, class SerfVecT, class PlusT>
void
FeudalPlusDataManager<MasterVecT,SerfVecT,PlusT>::
LoadData( const vec<int> & vecIds )
{
  mFeudalDataMgr.LoadData( vecIds ); 
}


template <class MasterVecT, class SerfVecT, class PlusT>
void
FeudalPlusDataManager<MasterVecT,SerfVecT,PlusT>::
LoadData( const int id )
{
  mFeudalDataMgr.LoadData( id );
}


template <class MasterVecT, class SerfVecT, class PlusT>
void
FeudalPlusDataManager<MasterVecT,SerfVecT,PlusT>::
LoadAllData()
{
  mFeudalDataMgr.LoadAllData();
}


template <class MasterVecT, class SerfVecT, class PlusT>
void
FeudalPlusDataManager<MasterVecT,SerfVecT,PlusT>::
Write( const bool bOverwrite,
       const String & strFeudalFile,
       const int lastId )
{
  // first save the mPlusData filed
  const String strFeudalPlusFile = strFeudalFile + "_plus";
  Ofstream( plusdata_strm, strFeudalPlusFile );
  plusdata_strm << mPlusData;
  plusdata_strm.close();

  // then save the other fields maintained by the parent FeudalDataManager
  mFeudalDataMgr.Write( bOverwrite,
			strFeudalFile,
			lastId );
}


template class FeudalPlusDataManager<vecFlowVector,FlowVector,FlowOrder>;

