// Copyright (c) 2005 Broad Institute of MIT and Harvard
//

#ifndef ANALYSIS_INFO_H
#define ANALYSIS_INFO_H

/// This class contains and gives access to a table of information about analysis.
///
/// \class AnalysisInfo
///

#include "String.h"
#include "Vec.h"

#include <iosfwd>
#include <map>

class AnalysisInfo {
public:
  typedef map< float, String > Map;
private:
  Map exp_, control_;
  String runname_, barcode_, wellsfile_, region_, numRegions_, plateSize_;

  ///Turn a KEY,REF string into a key value pair for the map.
  void update(Map &map, String value);
  /// Add the reference directory to all reference names.
  void addRefdir(Map &map, String refdir);
  ///Load an AnalysisInfo object from a stream;
  void ReadFrom( istream & in);

 public:

  ///Load a AnalysisInfo object from disk.
  AnalysisInfo( const String &filename);

  ///Load an AnalysisInfo object from an existing string.
  ///Sorry about the clumsy parameters to distinguish from file constructor...
  AnalysisInfo( int dummy, const String & text);

  ///Getters.
  vec<String> expKeys() const;  
  vec<String> controlKeys() const;  
  const Map & exp() const { return exp_; }
  const Map & control() const { return control_; }
  String runname() const { return runname_; }
  String barcode() const { return barcode_; }
  String wellsfile() const { return wellsfile_; }
  String region() const { return region_; }
  String numRegions() const { return numRegions_; }
  String plateSize() const { return plateSize_; }
  ulonglong wellsAvailable() const; 
  String GetReference(const String & key) const;
  String GetReference(float key) const;
};


#endif //ANALYSIS_INFO_H
