#!/usr/bin/perl -w

sub usage {
  print"Usage: evalfasta.pl mydata.fasta reference.fasta\n\n",
  "Evaluates mydata.fasta by aligning it to reference.fasta.\n",
  "Will produce the following file with the prefix mydata:\n",
  "mydata.qltout (long text output with all the alignments).\n",
  "Note that the \"mydata\" prefix includes any directories.\n\n";
}



if (@ARGV != 2) {
  usage();
  exit;
}

$fasta = $ARGV[0];
$reference = $ARGV[1];
if ($fasta !~ /(.*)\.(fa|fna|fasta)/ ) {
  $prefix = $fasta;
} else {
  $prefix = $1;
}

if (!( -e "$reference.lookuptable.lookup")) {
  system("MakeLookupTable SOURCE=$reference OUT_HEAD=$reference.lookuptable") && die "MakeLookupTable failed";
}

print "Aligning $fasta to $reference:\n";

open(HEUR,">$prefix.heuristics") || die "open heuristics file";
print HEUR "K=12 MM=30 MO=10 MC=0.3 END_STRETCH=2 MAX_FREQ=250 MIN_MATCHES_PERCENT=80 MIN_BASES_COVERED=30\n",
    "K=12 MM=22 MO=10 MC=0.22 END_STRETCH=2 MAX_FREQ=1000 MIN_MATCHES_PERCENT=80 MIN_BASES_COVERED=30\n",
    "K=12 MM=22 MO=20 MC=0.3 END_STRETCH=2 MAX_FREQ=10000 MIN_MATCHES_PERCENT=80  MIN_BASES_COVERED=30\n",
    "K=9 MM=22 MO=20 MC=0.3 END_STRETCH=2 MAX_FREQ=150000 MIN_MATCHES_PERCENT=85 MIN_BASES_COVERED=30\n";
close(HEUR);

system("QueryLookupTable SEQS=$fasta L=$reference.lookuptable.lookup TMP_DIR=. K=12 HEURISTICS=$prefix.heuristics PARSEABLE=True VISUAL=True > $prefix.orig.qltout") && die "QueryLookupTable failed";

system("Realign454 READS=$fasta REF=$reference ALIGNS=$prefix.orig.qltout OUT_PREFIX=$prefix TEXT_ALIGNS=$prefix.qltout UNPLACED_SEQUENCE_FILE=$prefix.unplaced.fasta") && die "Realign454 failed";

system ("rm -f $prefix.heuristics");
exit;
