#ifndef NORMALIZE_FLOW_VEC_H
#define NORMALIZE_FLOW_VEC_H
 
/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////
//
// \file NormalizeFlowVec.h: A single survival from the old
// Csv/AlignFlow.h module.  Still used in a couple of places.

#include "Vec.h"
#include "String.h"
#include "454/BaseFlow.h"

class FlowOrder;

// Normalizes the flow vec in place.  Returns true if the flow vec
// passes validation checks, or false if it fails.
bool
NormalizeFlowVec(vec<double> & query_flow_vec,
		 const FlowOrder &order,
		 const String &key);

struct FlowStats {
  double lowmean, highmean;
  double sum_unitvals;
  unsigned int num_unitvals;
  double avg_unitval;
  double sum_noise_values;
  unsigned int num_noise_flow, max_consec_noise_flows;
  double avg_noise_value;
  void clear()
  {
    lowmean=0; highmean=0;
    sum_unitvals=0;
    num_unitvals=0;
    avg_unitval=0;
    sum_noise_values=0;
    num_noise_flow=0; max_consec_noise_flows=0;
    avg_noise_value=0;
  }
};

ostream & operator<<(ostream &out, const FlowStats &s);

class FlowVecNormalizer {
public:
  FlowVecNormalizer(const FlowOrder &order,
		    const String &key); 
// Normalizes the flow vec in place. 
// Returns 0 if the flow vec passes, or a positive "reason" code if it fails.
  int operator()(vec<double> & query_flow_vec,
		 FlowStats &stats);
  double lowmeanMultiplier, lowHighmeanMultiplier, highHighmeanMultiplier;
  unsigned int    maxConsecNoiseFlowThreshold;
  unsigned int    minConsecNoiseFlowThreshold;
  double noiseFlowThreshold;	     
  double highNoiseThreshold;
  BaseFlowRef key;
  vec<int> lowbases, highbases;
  int firstreadbase;
};

#endif
