// Copyright (c) 2004 The Broad Institute at MIT and Harvard

// Kronos: a utility try to kill all your children

#ifndef KRONOS_H
#define KRONOS_H

#include <sys/types.h>
#if __sun == 1
//#include <system/dir.h>
#else
#include <sys/dir.h>
#endif
#include <sys/syscall.h>
// This requires the procfs file system, whose structure varies.
// ProcTree::Load_PPID_Data() has system-dependent code to handle it.
// sys/procfs might not even exist on other machines, so wrap #include:
#if defined __alpha || defined __ia64__
#include <sys/procfs.h>
#endif

#include <dirent.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <signal.h>

#include "CoreTools.h"
#include "Vec.h"

#include <map>
using std::map;
using std::multimap;

class ProcTree
{
 public:
  ProcTree() { Load_PPID_Data(); }
  vec<pid_t> children(pid_t pid);
  vec<pid_t> descendants(pid_t pid);
  vec<pid_t> my_descendants() { return(descendants(getpid())); }
  pid_t      ppid(pid_t pid) { return(ppid_map[pid]); }

 private:
  map<pid_t, pid_t> ppid_map;
  multimap<pid_t, pid_t> children_multimap;
  
  void Load_PPID_Data();
};

// overload kill to take a vec<pid_t> for pids
int kill(vec<pid_t> pids, int sig);

#endif
