/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2007) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef TIME_UTILS_H
#define TIME_UTILS_H

#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>
#include <stdlib.h>
#include "system/Types.h"
#include "String.h"

/**
 * PrintableFileDate
 *
 * Returns file date as in "2007/3/29".
 */
static String PrintableFileDate( const String &in_file )
{
  struct tm* clock;
  struct stat attrib;
  stat( in_file.c_str( ), &attrib );
  clock = localtime( &( attrib.st_mtime ) );

  String str_time
    = ToString( clock->tm_year + 1900 ) + "/"
    + ToString( 1 + clock->tm_mon ) + "/"
    + ToString( clock->tm_mday );
  
  return str_time;
}

// Logical type: intSeconds_t
// Number of seconds (for timeout alarms), as an integer.
typedef int intSeconds_t;

/**
   Class: TimeoutTimer

   Handles timeouts.  Provides a single global timer, 
*/
class TimeoutTimer {
 public:
  
  static void SetAlarm( intSeconds_t timeoutInSeconds ) {
    timeoutOccurred_ = False;
    signal( SIGALRM, handleTimeoutSignal );
    alarm( timeoutInSeconds );
  }

  static Bool TimeoutOccurred() { return timeoutOccurred_; }
    
 private:
  TimeoutTimer() { }

  static void handleTimeoutSignal(int) {
    timeoutOccurred_ = True;
  }
  
  static volatile Bool timeoutOccurred_;
  
};  // class Timer


#endif
