// Copyright (c) 2003 Broad Institute/Massachusetts Institute of Technology

#include "math/Functions.h"
#include "system/System.h"
#include "Vec.h"
#include "random/Random.h"
#include "random/Shuffle.h"

#include <algorithm>
#include <functional>
#include <stdlib.h>

class ShuffleRandom: public unary_function<int, int> {
 public:
  ShuffleRandom(longlong seed = 0) { srandomx(seed); }
  int operator()(int range = RAND_MAX) {
    if (range == RAND_MAX) return randomx();//save a modulo operation.
    return randomx() % range;
  }
};

/*
 * Shuffle
 */
void Shuffle( int N, vec<int> &shuffled, int seed )
{
  ForceAssertGt( N , 0 );

  shuffled.resize(N);
  for (int i=0; i<N; i++) shuffled[i] = i;

  ShuffleRandom generator(seed);

  random_shuffle(shuffled.begin(), shuffled.end(), generator);
}
