/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#include "CoreTools.h"
#include "random/PoissonTail.h"

// PoissonTail( lambda, n ): return
// sum_{k=0}^n exp[-lambda] * lambda^k / k!.
// This is probably not computed intelligently.

double PoissonTail( double lambda, int n )
{    double P = 0.0;
     double Y = 1.0;
     for ( int k = 0; k <= n; k++ )
     {    if ( k > 1 ) Y /= double(k);
          P += Y;
          Y *= lambda;    }
     return P * exp(-lambda);     }
