/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2007) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef BERNOULLI_H
#define BERNOULLI_H

#include "CoreTools.h"

// PartialBernoulliSum( n, k ): return sum_{i=0..k} choose(n,i).
//
// No attempt has been made to make this efficient or to pay attention to
// accuracy or overflow problems.

double PartialBernoulliSum( int n, int k );

// SurprisingTosses: Given a sequence of fair coin tosses, this looks at each 
// contiguous subsequence, and assigns it a p value, as follows: if it has length
// n and k heads in it, the p value is PartialBernoulliSum( n, Min( k, n-k ) )/2^n.
// The return value is the minimum of all these p values.
//
// No attempt has been made to make this efficient or to pay attention to
// accuracy or overflow problems.

double SurprisingTosses( const vec<Bool>& s, int max_seq = -1 );

double BinomialSum( int n, int k, double p );

#endif
