/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef PATHS_SIM_TRUESEQUENCEBROKER
#define PATHS_SIM_TRUESEQUENCEBROKER

#include "Basevector.h"
#include "String.h"
#include "ReadLocation.h"

#include "paths/KmerPath.h"

/// This class answers questions that require knowing the true
/// genomic data and locations that simulated reads are based on.
//
//  Code by David, added to the main() of MuxSearchInsert; later
//  cut-and-paste extracted therefrom and encapsulated in this class.

class SimTrueSequenceBroker {
public:
  SimTrueSequenceBroker() {}
  SimTrueSequenceBroker( String dataDir, String runDir, 
			 int K, const vec<int>& readLengths ) {
    LoadData( dataDir, runDir, K, readLengths );
  }

  void LoadData( String dataDir, String runDir, 
		 int K, const vec<int>& readLengths );

  /// Say whether truth is known as a KmerPath or as a basevector.

  Bool KmerPathMode( ) const { return mode == 1; }
  Bool BasevectorMode( ) const { return mode == 2; }

  /// The two reads must be oppositely oriented on the same contig.
  void SetInsert( int read_id1, int read_id2 );
  
  void SetRegion( int contig, int start, int stop );

  // Answer questions about the selected insert.

  // Genomic sequence of the insert, oriented with read_id1 on the right
  // (following the Mux-based insert walking convention).
  void GetTruth( KmerPath& truth ) const;
  void GetTruth( basevector& truth ) const;

  // Reads entirely contained within the insert.
  void GetFullyContainedReads( vec<int>& contained_reads_id1_dir,
			       vec<int>& contained_reads_id2_dir ) const;

  int Contig( ) const { return m; }
  int Start( ) const { return start; }
  int Stop( ) const { return stop; }

  // Returns sizes of reference sequences in bases.
  void GetReferenceSizes( vec<int>& ref_sizes ) const;

private:
  Bool mode;
  vec<read_location> true_locs;
  vec<int> true_locs_by_read;
  vecKmerPath genome_paths;
  vec< vec<int> > genome_starts;
  vecbasevector genome;
  int K;
  // Looks like we don't need to keep all of readLengths, just its max.
  int max_read;

  // used internally: info on which insert we're thinking about.
  const read_location* rl1_p;
  const read_location* rl2_p;
  int m;  // contig id.  Yes, really.
  int start;
  int stop;

};

#endif

