/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef UNIQUE_EXTEND_H
#define UNIQUE_EXTEND_H

#include "CoreTools.h"
#include "paths/HyperKmerPath.h"
#include "paths/PairedPair.h"

// Consider a pp_read whose elements refer to edges in a HyperKmerPath.
// UniqueExtend extends the edge sequence as far to the left and right as
// one can go unambiguously in the graph.  However, stop if cycling is
// encountered.  Also ignore edge e if edges_to_use[e] = False, thereby allowing
// for further extension.

void UniqueExtend( pp_read& r, int& left_add, int& right_add, 
     Bool aggressive_left, Bool aggressive_right, const HyperKmerPath& h,
     const vec<Bool>& edges_to_use, const vec<int>& to_left_vertex,
     const vec<int>& to_right_vertex, const Bool stay_in_nhood, 
     const vec<Bool>& hstart_known, const vec<int>& hstart, const int nhood_radius,
     const vec<int>& edgelengths );

#endif
