/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif

#include "CoreTools.h"
#include "paths/HyperKmerPath.h"
#include "paths/PairedPair.h"
#include "paths/UniqueExtend.h"

void UniqueExtend( pp_read& r, int& left_add, int& right_add, 
     Bool aggressive_left, Bool aggressive_right, const HyperKmerPath& h, 
     const vec<Bool>& edges_to_use, const vec<int>& to_left_vertex,
     const vec<int>& to_right_vertex, const Bool stay_in_nhood,      
     const vec<Bool>& hstart_known, const vec<int>& hstart, const int nhood_radius,
     const vec<int>& edgelengths )
{    int v = to_left_vertex[ r.front( ) ], w = to_right_vertex[ r.back( ) ];
     static vec<int> added, to, from;
     added.clear( );
     left_add = 0;
     right_add = 0;
     Bool too_far_left = False, too_far_right = False;
     if (stay_in_nhood)
     {    for ( int i = 0; i < r.isize( ); i++ )
          {    int e = r[i];
               if ( hstart_known[e] && hstart[e] + edgelengths[e] >= nhood_radius )
                    too_far_right = True;
               if ( hstart_known[e] && hstart[e] <= -nhood_radius )
                    too_far_left = True;    }    }
     while( !too_far_left )
     {    to.clear( );
          if ( !aggressive_left && !h.To(v).solo( ) ) break;
          for ( int j = 0; j < h.To(v).isize( ); j++ )
          {    int e = h.EdgeObjectIndexByIndexTo( v, j );
               if ( edges_to_use[e] ) to.push_back(j);    }
          if ( to.size( ) != 1 ) break;
          int e = h.EdgeObjectIndexByIndexTo( v, to[0] );
          if ( stay_in_nhood 
               && hstart_known[e] && hstart[e] + edgelengths[e] < -nhood_radius ) 
          {    break;    }
          r.insert( r.begin( ), e );
          left_add += edgelengths[e];
          if ( stay_in_nhood && hstart_known[e] && hstart[e] <= -nhood_radius ) 
               break;
          added.push_back(v);
          v = h.To(v)[ to[0] ];
          if ( Member( added, v ) ) break;    }
     added.clear( );
     while( !too_far_right )
     {    from.clear( );
          if ( !aggressive_right && !h.From(w).solo( ) ) break;
          for ( int j = 0; j < h.From(w).isize( ); j++ )
          {    int e = h.EdgeObjectIndexByIndexFrom( w, j );
               if ( edges_to_use[e] ) from.push_back(j);    }
          if ( from.size( ) != 1 ) break;
          int e = h.EdgeObjectIndexByIndexFrom( w, from[0] );
          if ( stay_in_nhood && hstart_known[e] && hstart[e] > nhood_radius ) break;
          r.push_back(e);
          right_add += edgelengths[e];
          if ( stay_in_nhood && hstart_known[e] 
               && hstart[e] + edgelengths[e] >= nhood_radius ) break;
          added.push_back(w);
          w = h.From(w)[ from[0] ];
          if ( Member( added, w ) ) break;    }    }
