/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef UNIPATH_SEEDS_H
#define UNIPATH_SEEDS_H

// UnipathSeeds: pick seed unipaths for LocalizeReads.

#include "CoreTools.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerPath.h"

void UnipathSeeds( 

     // inputs:

     const int MIN_KMERS_IN_SEED,              // smallest seed to consider
     const vec<int>& ulen,                     // unipath lengths
     const vec<Bool>& normal,                  // is a given unipath normal 
     const vec<int>& predicted_copyno,         // predicted copy number for unipaths
     const digraphE<sepdev>& G,                // graph of all normal unipaths
     const digraphE<fsepdev>& FG,              // graph of all normal unipaths
     const Bool USE_TRUTH,                     // is this simulated data?
     vecvec<placement> locs,                   // unipath locations on reference
     const Bool UNUSED_SEED_STATS,             // show details about unused seeds?
     const Bool DUMP_TRUE_LOCS,                // print true locations of used seeds?
     const int MAX_SEED_DIST,                  // must use seed if farther than this
     const vecbasevector& genome,              // the reference

     // output:

     vec<int>& seeds, 

     // optional:

     int verbosity = 0

          );

#endif
