// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

#include "paths/SubsumptionList.h"

#include "FeudalTemplate.h"
#include "system/SystemTemplate.h"

// Functions to translate pathIds to indexes and back.

OrientedKmerPathId  PathIdFromIndex( int index ) 
{
  return OrientedKmerPathId( index/2, index&1 ); 
}
  
int IndexFromPathId( const OrientedKmerPathId& pathId )
{
  return pathId.GetId()*2 + pathId.IsRc(); 
}

void
BriefSubsumptionRecord::Write( ostream& out ) const
{
  m_superPath.Write( out );
  BinWrite( out, m_leftOverhang );
}


void
BriefSubsumptionRecord::Read( istream& in ) 
{
  m_superPath.Read( in );
  BinRead( in, m_leftOverhang );
}


void
SubsumptionList::SetBriefRecordsFor( const OrientedKmerPathId& subsumedRead,
                                     const vec<BriefSubsumptionRecord>& records )
{
  serfvec<BriefSubsumptionRecord>& ownedVec = m_list[ IndexFromPathId( subsumedRead ) ];

  ownedVec.clear();
  ownedVec.reserve( records.size() );
  copy( records.begin(), records.end(),
        back_inserter( ownedVec ) );
}


void
SubsumptionList::GetFullRecordsFor( const OrientedKmerPathId& subsumedRead,
                                    vec<SubsumptionRecord>& records ) const
{
  const serfvec<BriefSubsumptionRecord>& briefRecords = m_list[ IndexFromPathId( subsumedRead ) ];
  records.clear();
  records.reserve( briefRecords.size() );
  for ( serfvec<BriefSubsumptionRecord>::const_iterator briefIter = briefRecords.begin();
        briefIter != briefRecords.end(); ++briefIter )
    records.push_back( SubsumptionRecord( subsumedRead, *briefIter ) );
}


void
SubsumptionList::Write( const String& filename ) const
{
  m_list.WriteAll( filename );
}


void
SubsumptionList::Read( const String& filename )
{
  m_list.ReadAll( filename );
}

template void ReadPointer( int filedes, BriefSubsumptionRecord*& ptr );

INSTANTIATE_MASTERVEC( serfvec<BriefSubsumptionRecord>, BriefSubsumptionRecord )
