// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

#ifndef PATHS_SUBMUXGRAPHBUILDER
#define PATHS_SUBMUXGRAPHBUILDER

#include "paths/MuxFinder.h"
#include "paths/FindSubsumedReads.h"
#include "paths/KmerPathMuxSearcher.h"

/// Suppose you have a (small) subset of the reads, and you want to 
/// walk using only that subset.  Is it feasible to rebuild that
/// portion of the mux graph on the fly?  This class tries it.
///
/// It produces everything a KmerPathMuxSearcher needs, then
/// creates the searcher, and makes it available to search with.

class SubMuxGraphBuilder {
public:
  SubMuxGraphBuilder()
    : mp_pathsDb(0), mp_muxGraph(0), mp_fillDb(new ReadFillDatabase()), 
      mp_subList(0), mp_searcher(0), m_verbose(false), m_minNumKmers(1), 
      m_minOverlap(1)
  {}

  SubMuxGraphBuilder( const vecKmerPath& pathsFw, 
		      const vecKmerPath& pathsRc )
    : mp_pathsDb(0), mp_muxGraph(0), mp_fillDb(new ReadFillDatabase()), 
      mp_subList(0), mp_searcher(0), m_verbose(false), m_minNumKmers(1), 
      m_minOverlap(1)
  {
    BuildFromPaths( pathsFw, pathsRc );
  }

  ~SubMuxGraphBuilder() {
    DeleteStuff();
    delete mp_fillDb;
  }

  void SetVerbose(bool verb) { m_verbose = verb; }
  void SetMinNumKmers( int minNumKmers ) { m_minNumKmers = minNumKmers; }
  void SetMinOverlap( int minOverlap ) { m_minOverlap = minOverlap; }

  // Here is the raw material; make me a KmerPathMuxSearcher.
  void BuildFromPaths( const vecKmerPath& pathsFw, 
		       const vecKmerPath& pathsRc,
                       const int partition = 0 );

  void BuildFromSomePaths( vecKmerPath& pathsFw, 
			   vecKmerPath& pathsRc,
			   const vec<int>& subset_Fw,
			   const vec<int>& subset_Rc );

  KmerPathMuxSearcher& GetSearcher() { return *mp_searcher; }

  MuxGraph& GetMuxGraph() { return *mp_muxGraph; }

  const SubsumptionList& GetSubList() { return *mp_subList; }

  const vec<int>& GetReadLengths() { return m_readLengthsInKmers; }

  void BigPictureDot( const String& filename, const int partition ) const;

private:
  void DeleteStuff() {
    delete mp_pathsDb;
    delete mp_muxGraph;
    delete mp_subList;
    delete mp_searcher;
  }

  vec<int> m_readLengthsInKmers;

  KmerPathDatabase* mp_pathsDb;
  MuxGraph* mp_muxGraph;
  ReadFillDatabase* mp_fillDb;  // the trivial one
  SubsumptionList* mp_subList;
  KmerPathMuxSearcher* mp_searcher;

  bool m_verbose;
  int m_minNumKmers;
  int m_minOverlap;
};

#endif
