/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef SHARED_COUNTER_H
#define SHARED_COUNTER_H

#include "CoreTools.h"

// IncrementSharedCounter( fd, x, max_x ): 
// (a) camp on file descriptor fd until it can be locked;
// (b) read text integer x from beginning of file, write x + 1
//     (but don't increment in-memory value of x);
// (c) unlock fd.
//
// If max_x is specified and x = max_x, don't write.

void IncrementSharedCounter( int fd, int& x, int max_x = -1 );


// InspectSharedCounter( fd, x ): 
// (a) camp on file descriptor fd until it can be locked;
// (b) read text integer x from beginning of file;
// (c) unlock fd.

void InspectSharedCounter( int fd, int& x);

#endif
