/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#include <errno.h>

#include "CoreTools.h"
#include "paths/SharedCounter.h"

void IncrementSharedCounter( int fd, int& x, int max_x )
{    struct flock lock;
     lock.l_type = F_WRLCK;
     lock.l_whence = SEEK_SET;
     lock.l_start = 0;
     lock.l_len = 0;
     if ( fcntl( fd, F_SETLKW, &lock ) != 0 )
     {    FatalErr( "Attempt to set shared counter lock failed "
               << ErrnoExplanation(errno) << "." );    }
     lseek( fd, 0, SEEK_SET );
     const int bufsize = 12;
     char buf[bufsize];
     if ( read( fd, buf, bufsize ) == -1 )
     {    FatalErr( "Attempt to read shared counter file failed "
               << ErrnoExplanation(errno) << "." );    }
     x = 0;
     for ( int j = 0; j < bufsize; j++ )
     {    if ( buf[j] == '\n' ) break;
          x = ( 10 * x ) + ( buf[j] - '0' );    }
     if ( max_x < 0 || x < max_x )
     {    String nextx = ToString( x + 1 ) + "\n";
          lseek( fd, 0, SEEK_SET );
          if ( write( fd, nextx.c_str( ), nextx.size( ) + 1 ) == -1 )
          {    FatalErr( "Attempt to write shared counter file failed "
                    << ErrnoExplanation(errno) << "." );    }    }
     lock.l_type = F_UNLCK;
     if ( fcntl( fd, F_SETLKW, &lock ) != 0 )
     {    FatalErr( "Attempt to unset shared counter lock failed "
               << ErrnoExplanation(errno) << "." );    }    }


void InspectSharedCounter( int fd, int& x)
{    struct flock lock;
     lock.l_type = F_WRLCK;
     lock.l_whence = SEEK_SET;
     lock.l_start = 0;
     lock.l_len = 0;
     if ( fcntl( fd, F_SETLKW, &lock ) != 0 )
     {    FatalErr( "Attempt to set shared counter lock failed "
               << ErrnoExplanation(errno) << "." );    }
     lseek( fd, 0, SEEK_SET );
     const int bufsize = 12;
     char buf[bufsize];
     if ( read( fd, buf, bufsize ) == -1 )
     {    FatalErr( "Attempt to read shared counter file failed "
               << ErrnoExplanation(errno) << "." );    }
     x = 0;
     for ( int j = 0; j < bufsize; j++ )
     {    if ( buf[j] == '\n' ) break;
          x = ( 10 * x ) + ( buf[j] - '0' );    }
     lock.l_type = F_UNLCK;
     if ( fcntl( fd, F_SETLKW, &lock ) != 0 )
     {    FatalErr( "Attempt to unset shared counter lock failed "
               << ErrnoExplanation(errno) << "." );    }    }
