/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// ReadsToPathsCoreX.  This is like ReadsToPathsCore, except that it doesn't
// do any i/o, generates only the paths, and doesn't offer as many options.

#ifndef READS_TO_PATHS_COREX_H
#define READS_TO_PATHS_COREX_H

#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "paths/KmerPath.h"

void ReadsToPathsCoreX( const vecbasevector& EE, const unsigned int& K, 
     const longlong genome_size, vecKmerPath& paths );

// ReadsToPathsCoreX will fail if it faces the prospect 
// of a KmerPathInterval with length greater than 65535.
// ReadsToPathsCoreY is a wrapper which solves this.

void ReadsToPathsCoreY( const vecbasevector& EE, const unsigned int& K, 
     const longlong genome_size, vecKmerPath& paths, int max_interval = 60000 );

// These versions of ReadsToPathsCoreY generate paths_rc and pathsdb as well.

void ReadsToPathsCoreY( const vecbasevector& EE, const unsigned int& K, 
     const longlong genome_size, vecKmerPath& paths, vecKmerPath& paths_rc,
     vec<tagged_rpint>& pathsdb, int max_interval = 60000 );

void ReadsToPathsCoreY( const vecbasevector& EE, const unsigned int& K, 
     const longlong genome_size, vecKmerPath& paths, vecKmerPath& paths_rc,
     vec<big_tagged_rpint>& pathsdb, int max_interval = 60000 );

#endif
