/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// ReadsToPathsCore.  See documentation in ReadsToPaths.cc.
//
// Note: see also ReadsToPathsCoreX.h.

#ifndef READS_TO_PATHS_CORE_H
#define READS_TO_PATHS_CORE_H

#include "CoreTools.h"

void ReadsToPathsCore( const String& PRE, const String& DATA, const String& RUN,
     const String& HEAD, const unsigned int& K, const Bool& VERBOSE,
     const Bool& BREAK_LONG, const String& GENOME_SIZE, 
     const Bool& USE_QUALITY_SCORES, const Bool& PATHS_ONLY, ostream& out );

inline void ReadsToPathsCore( const String& PRE, const String& DATA, 
     const String& RUN, const String& HEAD, const unsigned int& K, 
     const Bool& VERBOSE, const Bool& BREAK_LONG, const String& GENOME_SIZE, 
     const Bool& USE_QUALITY_SCORES, const Bool& PATHS_ONLY, const String& logfile )
{    Ofstream( out, logfile );
     ReadsToPathsCore( PRE, DATA, RUN, HEAD, K, VERBOSE, BREAK_LONG, GENOME_SIZE, 
          USE_QUALITY_SCORES, PATHS_ONLY, out );    }

#endif
