/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// Given the list of pp_pairs for a neighborhood, together with their 
// multiplicities, and underlying information for the library, look for pp_pairs
// in the list that appear to be false, by testing coverage.  

#ifndef POORLY_COVERED_PAIRS_H
#define POORLY_COVERED_PAIRS_H

#include "CoreTools.h"
#include "paths/HyperKmerPath.h"
#include "paths/PairedPair.h"

void DetectPoorlyCoveredPairs( 

     const HyperKmerPath& h,           // the HyperKmerPath
     vec<pp_pair>& ppp,                // the pairs
     vec<int>& pppmult,                // their multiplicities
     vec<Bool>& ppp_trusted,
     const vec<Bool>& unique_edge,     // which edges are believed to be unique
     const vec<Bool>& hstart_known,
     const vec<int>& hstart,
     const int NHOOD_RADIUS_INTERNAL,
     const double mean_read_length,    // for the short-insert pairs, in kmers
     const double coverage,            // by the short-insert pairs (half)
     const double mean_insert_length,  // of the short-insert pairs, in kmers
     const double insert_dev,          // insert length deviation
     const int sim_cov,                // coverage level used in simulation
     Bool verbose
     
          );

#endif
