/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef PATHS_PDF_ENTRY
#define PATHS_PDF_ENTRY

// Struct: pdf_entry
//
// The struct pdf_entry is meant to replace pair<int,double> as a way
// of holding the predicted copy number of unipaths (for a given copy
// number the probability that the unipath has that copy number).  
// Its natural habitat is the vecvec<pdf_entry>.
//
// pair<int,double> itself is bad because alignment forces it to have 
// padding on a 64-bit machine but not on a 32-bit, so a 
// vecvec< pair<int,double> > stored on disk is not cross-compatible.
struct pdf_entry {
  // field names are meant to minimize code changes from pair<int,double>
public:
  int first;
private:
  int PADDING_NEEDED_BY_64_BIT_MACHINES__DO_NOT_USE;
public:
  double second;

  pdf_entry() {}
  pdf_entry(int i, double d) : first(i), second(d) { }

  // No one will ever use these,  but just for show:
  int NumCopies() const { return first; }
  double Prob() const { return second; }
};

#endif
