// Copyright (c) 2004 Broad Institute/Massachusetts Institute of Technology

#ifndef FORCE_DEBUG
    #define NDEBUG
#endif

#include "paths/PathWalk.h"
#include "Vec.h"

int PathWalk::s_count = 0;


// Does this PathWalk actually contain a well-located copy of the closer
// (even if its kmers were added by other paths, so !ContainsCloser()) ?
// -- actually for now do a weaker test: does this contain the final
// kmer of the closer in a legally mergeable way?
//
// If so, create a new PathWalk which knows about the closer.
// Return all such in the last argument.
// (So the return value is just !new_closed_walks.empty() -- hmmm.)
//
// NOTE: this does not (and cannnot) do negative gap checking on the merger!

bool PathWalk::CanAddCloser( const KmerPath& closer,
			     int minGoodPathLength, 
			     int maxGoodPathLength,
			     vec<PathWalk>& new_closed_walks,
			     bool DEBUG ) const {
  if(DEBUG) {
    cout << "Entering CanAddCloser" << endl;
    PRINT(m_path);
    PRINT(closer);
  }

  new_closed_walks.clear();
  int min_seen=0, max_seen=0;
  longlong final_kmer = closer.End().GetKmer();

  for( int seg=0; seg < m_path.NSegments(); seg++ ) {
    if( minGoodPathLength <= max_seen + final_kmer-m_path.Start(seg)+1 &&
	maxGoodPathLength >= min_seen + final_kmer-m_path.Start(seg)+1 &&
	m_path.isSeq(seg) &&
	m_path.Segment(seg).Contains( final_kmer ) ) {
      if(DEBUG) cout << "Found a good segment " << m_path.Segment(seg) << endl;
      vec<MergedKmerPath> mergers;
      MergePaths( m_path, closer, seg, closer.NSegments()-1, mergers );
      if(DEBUG) cout << "MergePaths found " << mergers.size() << " mergers" << endl;
      // Create new PathWalks for any successful mergers.
      // (Trim right end to end of closer and set containsCloser=true.)
      for( vec<MergedKmerPath>::iterator merger = mergers.begin();
	   merger != mergers.end(); merger++ ) {
	KmerPathLoc stop( merger->path, merger->given );
	stop.SetKmer( final_kmer );
	KmerPath resultPath;
	merger->path.CopySubpath( merger->path.Begin(), stop, resultPath );
	int first_affected = max( merger->left_end.first,
				  merger->left_end.second );
	int new_index=0;
	for(int seg=0; seg<first_affected-1; seg++)  // -1 in case gap shrunk
	  if(resultPath.isGap(seg)) new_index++;
	PathWalk newWalk( resultPath, new_index, true );
	newWalk.RequireReadsFrom( *this );
	new_closed_walks.push_back( newWalk );
      }
    }
    min_seen += m_path.MinLength(seg);
    max_seen += m_path.MaxLength(seg);
  }

  return (! new_closed_walks.empty());
}

