/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef PAIRED_WALK_H
#define PAIRED_WALK_H

#include "CoreTools.h"
#include "paths/PairedPair.h"

// Version of paired walk right that walks certain of the pairs ppp, as 
// specified by the argument to_walk.

void PairedWalkRight( const vec<pp_pair> ppp, const vec<Bool>& to_walk,
     const vec<int>& L, const double dmult, vec< vec<pp_closure> >& closures, 
     const int max_opens, Bool create_closures_if_fail, vec<Bool>& fail, 
     int verbosity, int max_nodes );

// Version of PairedWalkRight that walks right into space, starting with
// templates, then returns all closures that are subsumed by the resulting tree.
// The "closures" argument has one entry for each element of ppp, rather than
// one entry for each element of templates.

void PairedWalkRight( const vec<pp_pair> ppp, const vec<pp_closure>& templates, 
     const int max_walk, const vec<int>& L, const double dmult, 
     const vec< vec<pp_closure> >& known_closures, vec< vec<pp_closure> >& closures,
     vec<pp_read>& chunks, const int max_opens, int verbosity, int max_nodes );

// Reverse of this:

inline void PairedWalkLeft( const vec<pp_pair> ppp, const vec<pp_closure>& templates,
     const int max_walk, const vec<int>& L, const double dmult, 
     const vec< vec<pp_closure> >& known_closures, vec< vec<pp_closure> >& closures, 
     vec<pp_read>& chunks, const int max_opens, int verbosity, int max_nodes )
{    vec<pp_pair> pppr(ppp);
     for ( int i = 0; i < pppr.isize( ); i++ )
          pppr[i].ReverseMe( );
     vec<pp_closure> templatesr(templates);
     for ( int i = 0; i < templatesr.isize( ); i++ )
          templatesr[i].ReverseMe( );
     for ( int i = 0; i < chunks.isize( ); i++ )
          chunks[i].ReverseMe( );
     vec< vec<pp_closure> > known_closuresr(known_closures);
     for ( int i = 0; i < known_closuresr.isize( ); i++ )
     {    for ( int j = 0; j < known_closuresr[i].isize( ); j++ )
               known_closuresr[i][j].ReverseMe( );    }
     PairedWalkRight( pppr, templatesr, max_walk, L, dmult, known_closuresr, 
          closures, chunks, max_opens, verbosity, max_nodes );
     for ( int i = 0; i < chunks.isize( ); i++ )
          chunks[i].ReverseMe( );
     for ( int i = 0; i < closures.isize( ); i++ )
     {    for ( int j = 0; j < closures[i].isize( ); j++ )
               closures[i][j].ReverseMe( );    }    }

// General version of PairedWalkRight: does both of the two "right" operations.
// This is intended for internal use only.

void PairedWalkRight( const vec<pp_pair> ppp, const vec<Bool>& to_walk,
     const vec<pp_closure>& templates, const int max_walk, const vec<int>& L, 
     const double dmult, const vec< vec<pp_closure> >& known_closures,
     vec< vec<pp_closure> >& closures, vec<pp_read>& chunks, 
     const int max_opens, Bool create_closures_if_fail, vec<Bool>& fail, 
     int verbosity, int max_nodes );

// Implementation of its two specializations:

inline void PairedWalkRight( const vec<pp_pair> ppp, const vec<Bool>& to_walk,
     const vec<int>& L, const double dmult, vec< vec<pp_closure> >& closures, 
     const int max_opens, Bool create_closures_if_fail, vec<Bool>& fail, 
     int verbosity, int max_nodes )
{    static vec<pp_closure> templates;
     vec< vec<pp_closure> > known_closures;
     vec<pp_read> chunks;
     PairedWalkRight( ppp, to_walk, templates, 0, L, dmult, known_closures, 
          closures, chunks, max_opens, create_closures_if_fail, fail, 
          verbosity, max_nodes );    }

inline void PairedWalkRight( const vec<pp_pair> ppp, 
     const vec<pp_closure>& templates, const int max_walk, const vec<int>& L, 
     const double dmult, const vec< vec<pp_closure> >& known_closures, 
     vec< vec<pp_closure> >& closures, vec<pp_read>& chunks, 
     const int max_opens, int verbosity, int max_nodes )
{    vec<Bool> to_walk, fail;
     PairedWalkRight( ppp, to_walk, templates, max_walk, L, dmult, known_closures,
          closures, chunks, max_opens, True, fail, verbosity, max_nodes );    }

#endif
