/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// NearUnipathErrors.  Find reads that should be untrusted ...

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif

#include "CoreTools.h"
#include "Feudal.h"
#include "math/Functions.h"
#include "paths/KmerPath.h"
#include "paths/NearUnipathErrors.h"
#include "paths/UnipathCoverageCore.h"

void NearUnipathErrors( 
     // inputs:
     const vecKmerPath& paths,
     const vecKmerPath& paths_rc,
     const vec<tagged_rpint>& pathsdb,
     const vecKmerPath& unipaths,
     const vec<int>& predicted_copyno,
     const vec<double>& predicted_copyno_p,
     // output:
     vec<Bool>& to_delete )

{
     to_delete.resize( paths.size( ), False );
     int nuni = unipaths.size( );
     for ( int i = 0; i < nuni; i++ )
     {    if ( predicted_copyno[i] != 1 ) continue;
          if ( predicted_copyno_p[i] < 0.95 ) continue;
          for ( int pass = 1; pass <= 2; pass++ )
          {    static KmerPath u;
               u = unipaths[i];
               if ( pass == 2 ) u.Reverse( );
               longlong last = u.Stop( u.NSegments( ) - 1 );
               static vec<longlong> con;
               Contains( pathsdb, last, con );
               cout << "\nprojections off unipath " << i << " "
                    << ( pass == 1 ? "fw" : "rc" ) << " (l=" << u.KmerCount( )
                    << "):\n";
               vec< vec<longlong> > M( con.size( ) );
               int maxtail = 0;
               for ( int j = 0; j < con.isize( ); j++ )
               {    const tagged_rpint& t = pathsdb[ con[j] ];
                    int id = t.ReadId( );
                    const KmerPath& p 
                         = ( t.PathId( ) >= 0 ? paths[id] : paths_rc[id] );
                    int pos = t.PathPos( );
                    static KmerPath tail;
                    tail.Clear( );
                    if ( last < t.Stop( ) ) tail.AddSegment( last+1, t.Stop( ) );
                    for ( int k = pos + 1; k < p.NSegments( ); k++ )
                         tail.AddSegment( p.Segment(k) );
                    cout << tail << "\n";    
                    for ( int k = 0; k < tail.NSegments( ); k++ )
                    {    for ( longlong l = tail.Start(k); l <= tail.Stop(k); l++ )
                              M[j].push_back(l);    }
                    maxtail = Max( maxtail, M[j].isize( ) );    }
               for ( int j = 0; j < maxtail; j++ )
               {    static vec<longlong> x;
                    x.clear( );
                    for ( int l = 0; l < M.isize( ); l++ )
                         if ( j < M[l].isize( ) ) x.push_back( M[l][j] );
                    Sort(x);
                    vec< pair<int,longlong> > xc;
                    for ( int k = 0; k < x.isize( ); k++ )
                    {    int l;
                         for ( l = k + 1; l < x.isize( ); l++ )
                              if ( x[l] != x[k] ) break;
                         xc.push_back( make_pair( l - k, x[k] ) );
                         k = l - 1;    }
                    if ( xc.size( ) == 1 ) continue;
                    ReverseSort(xc);
                    cout << "first branch:\n";
                    for ( int k = 0; k < xc.isize( ); k++ )
                         cout << xc[k].first << " " << xc[k].second << "\n";
                    static vec<longlong> bads;
                    bads.clear( );
                    if ( xc[0].first >= 10 * xc[1].first )
                    {    for ( int k = 1; k < xc.isize( ); k++ )
                              bads.push_back( xc[k].second );    }
                    for ( int l = 0; l < M.isize( ); l++ )
                    {    if ( j < M[l].isize( ) ) 
                         {    if ( Member( bads, M[l][j] ) )
                              {    const tagged_rpint t = pathsdb[ con[l] ];
                                   cout << "delete read " << t.ReadId( ) << "\n";
                                   to_delete[ t.ReadId( ) ] = True;    }    }    }
                    break;    }    }    }    }
