/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#include "CoreTools.h"
#include "Feudal.h"
#include "paths/FindSubsumedReads.h"
#include "paths/KmerPath.h"
#include "paths/KmerPathDatabase.h"
#include "paths/MuxFinder.h"
#include "paths/MuxGraph.h"
#include "paths/SubsumptionList.h"

void MuxSetup( const String& PRE, const String& DATA, const String& RUN,
     int nreads, int K )
{    String run_dir = PRE + "/" + DATA + "/" + RUN;
     String PRE_DATA_RUN = "PRE=" + PRE + " DATA=" + DATA + " RUN=" + RUN;
     SymlinkForce( run_dir + "/reads.paths.k" + ToString(K),
          run_dir + "/reads.pathshq.k" + ToString(K) );
     SymlinkForce( run_dir + "/reads.paths_rc.k" + ToString(K),
          run_dir + "/reads.pathshq_rc.k" + ToString(K) );
     SymlinkForce( run_dir + "/reads.pathsdb.k" + ToString(K),
          run_dir + "/reads.pathshqdb.k" + ToString(K) );
     vec<int> left_trim(nreads, 0), right_trim(nreads, 0);
     BinaryWrite2( run_dir + "/reads.paths.left_trim.k" + ToString(K), left_trim );
     BinaryWrite2( run_dir + "/reads.paths.right_trim.k" + ToString(K), right_trim );

     // Essentially equivalent to:
     // SystemSucceed( "FindMuxes " + PRE_DATA_RUN + " K=" + ToString(K) 
     //     + " minNumKmers=1 > " + run_dir + "/FindMuxes.log" );

     vecKmerPath pathsFw( run_dir + "/reads.pathshq.k" + ToString(K) );
     vecKmerPath pathsRc( run_dir + "/reads.pathshq_rc.k" + ToString(K) );
     BREAD2( run_dir + "/reads.pathshqdb.k" + ToString(K), 
          vec<tagged_rpint>, rawPathsDB );
     KmerPathDatabase pathsDb( &rawPathsDB );
     Ofstream( logstrm, run_dir + "/FindMuxesSubsumptions.log" );
     MuxFinder theMuxFinder( pathsFw, pathsRc, pathsDb, &logstrm );
     theMuxFinder.SetVerbose( false );
     theMuxFinder.StudyReads();
     theMuxFinder.SetMinNumKmers( 1 );
     theMuxFinder.SetPrintHiMuxCount( False );
     MuxGraph theMuxGraph( pathsFw.size() );
     longlong numMuxes = theMuxFinder.FindMuxes( 
          theMuxGraph, 100000, 0, pathsDb.size()-1 );
     logstrm << Date() << ": Found " << numMuxes << " minimal extensions." << endl;
     theMuxGraph.Write( run_dir + "/reads.pathshq_muxgraph.k" + ToString(K) );

     // Essentially equivalent to:
     // SystemSucceed( "FindSubsumptions " + PRE_DATA_RUN + " K=" + ToString(K) 
     //     + " minNumKmers=1 > " + run_dir + "/FindSubsumptions.log" );

     SubsumptionList theSubList( pathsFw.size() );
     longlong numSubsumed = FindSubsumedReads( 
          theSubList, pathsFw, pathsRc, pathsDb, 1, 100000, &logstrm );
     logstrm << Date() << ": Found " << numSubsumed << " subsumed reads." << endl;
     theSubList.Write( run_dir + "/reads.pathshq_sublist.k" + ToString(K) );    }
