/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef MERGE_COPY_NUMBER_TWO_H
#define MERGE_COPY_NUMBER_TWO_H

#include "CoreTools.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"
#include "paths/PairedPair.h"

void MergeCopyNumberTwo( const HyperKmerPath& h, const KmerBaseBroker& kbb,
     vec<pp_pair>& ppp, const vec<int>& L, const vec<vrtx_t>& to_left_vertex, 
     const vec<vrtx_t>& to_right_vertex, const digraphE<int>& G, 
     const vec<int>& edge_copyno, vec<Bool>& remove, const Bool verbose );

Bool MaybeOneBeforeTwo( const pp_read& r1, const double p1, const double d1,
     const pp_read& r2, const double p2, const double d2, const double dmult,
     const vec<int>& L, const digraphE<int>& G, const vec<vrtx_t>& to_left_vertex,
     const vec<vrtx_t>& to_right_vertex );

void GeneratePairsEdge( const vec<pp_pair>& ppp, const vec<int>& edge_copyno,
     vec< pair< vec<int>, int > >& pairs_edge, const vec<Bool>& remove );

#endif
