/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef MERGE_AND_TIGHTEN_H
#define MERGE_AND_TIGHTEN_H

#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "graph/Digraph.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"
#include "paths/PairedPair.h"
#include "paths/simulation/Placement.h"

void MergeAndTighten( vec<pp_pair>& ppp, const vec<int>& pppL,
     vec<Bool> safe_unique, const double dmult,
     const vec<vrtx_t>& to_right_vertex, const vec<vrtx_t>& to_left_vertex,
     const vec<Bool>& hstart_known, const vec<int>& hstart,
     const int NHOOD_RADIUS, const int NHOOD_RADIUS_INTERNAL,
     const digraphE<int>& G, const vec<Bool>& editable, const vec<int>& edge_copyno,
     const vec<double>& edge_copyno_p, vec<Bool>& remove, const Bool verbose, 
     const Bool MERGE_COPY_NUMBER_TWO, const int SHOW_PAIR_PLACEMENTS, 
     const String& sub_dir, const HyperKmerPath& h, const KmerBaseBroker& kbb, 
     const vecbasevector& genome, const serfvec<placement>& locsv, 
     const Bool MERGE_COPY_NUMBER_TWO_VERBOSE );

#endif
