/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef LOCALIZE_READS_TAIL_H
#define LOCALIZE_READS_TAIL_H

#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "ReadLocation.h"
#include "ReadPairing.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"

void LocalizeReadsTail( const String& sub_dir, 
     const vec<HyperBasevector>& hyperbases, int K,
     const String& KS, const String& wrun_dir, const int MIN_OVERLAP_FINAL,
     const int MIN_PROPER_OVERLAP_FINAL, const Bool GLOBAL_CLEAN,
     const Bool SHOW_PAIR_ALIGNS, const vec<read_pairing>& pairs,
     const vec<int>& pairs_index, const vec<int>& partner, 
     const vecbasevector& reads, const KmerBaseBroker* gkbb, 
     const vecKmerPath& unipaths, const vec<read_location_short>& ulocs, 
     const vecvec<int>& ulocs_indexr, const int MAX_SHORT_INSERT_SEP,
     const Bool FILTER_ALIGNS, const vecbasevector& genome,
     const Bool FINAL_MERGE, const Bool USE_TRUTH, const String& data_dir,
     int nreads, Bool verbose, const vec<int>& predicted_copyno,
     const int MIN_COMPONENT, const vec<read_location>& readlocs,
     const vec<int>& readlocs_index, const Bool DIPLOID,
     const Bool OLD_INTERNAL_MERGE = False,
     const Bool disambiguate_simple_loops_verbose = False,
     const Bool pull_verbose = False,
     const Bool track_global_clean_changes = False,
     const Bool SHORTEST_MERGE = False,
     const Bool NEW_POORLY_COVERED = False );

#endif
