/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif

#include "Alignment.h"
#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "ReadLocation.h"
#include "ReadPairing.h"
#include "paths/AlignHyperKmerPath.h"
#include "paths/EvalUtils.h"
#include "paths/GlobalClean.h"
#include "paths/HyperKmerPath.h"
#include "paths/InternalMerge.h"
#include "paths/LocalizeReadsTail.h"
#include "paths/KmerBaseBroker.h"
#include "paths/ReadsToPathsCore.h"
#include "paths/ReadsToPathsCoreX.h"

// This is just the tail end of LocalizeReads.

void LocalizeReadsTail( const String& sub_dir, 
     const vec<HyperBasevector>& hyperbases, int K,
     const String& KS, const String& wrun_dir, const int MIN_OVERLAP_FINAL,
     const int MIN_PROPER_OVERLAP_FINAL, const Bool GLOBAL_CLEAN,
     const Bool SHOW_PAIR_ALIGNS, const vec<read_pairing>& pairs,
     const vec<int>& pairs_index, const vec<int>& partner, 
     const vecbasevector& reads, const KmerBaseBroker* gkbb, 
     const vecKmerPath& unipaths, const vec<read_location_short>& ulocs, 
     const vecvec<int>& ulocs_indexr, const int MAX_SHORT_INSERT_SEP,
     const Bool FILTER_ALIGNS, const vecbasevector& genome,
     const Bool FINAL_MERGE, const Bool USE_TRUTH, const String& data_dir,
     int nreads, Bool verbose, const vec<int>& predicted_copyno,
     const int MIN_COMPONENT, const vec<read_location>& readlocs,
     const vec<int>& readlocs_index, const Bool DIPLOID,
     const Bool OLD_INTERNAL_MERGE, const Bool disambiguate_simple_loops_verbose,
     const Bool pull_verbose, const Bool track_global_clean_changes,
     const Bool SHORTEST_MERGE, const Bool NEW_POORLY_COVERED )

{
     // Load, do some translation.

     vec<HyperKmerPath> hypers;
     vecbasevector bases;
     longlong nbases = 0, nseqs = 0;
     for ( int pass = 1; pass <= 2; pass++ )
     {    if ( pass == 2 ) bases.Reserve( nbases/16 + nseqs, nseqs );
          for ( int i = 0; i < hyperbases.isize( ); i++ )
          {    for ( int j = 0; j < hyperbases[i].EdgeObjectCount( ); j++ )
               {    const basevector& e = hyperbases[i].EdgeObject(j);
                    if ( pass == 1 )
                    {    nseqs += 1;
                         nbases += e.size( );    }
                    else bases.push_back(e);    }    }    }
     int edges0 = bases.size( );
     for ( int i = 0; i < unipaths.size( ); i++ )
          bases.push_back_reserve( gkbb->Seq( unipaths[i] ) );
     bases.WriteAll( sub_dir + "/run/reads.fastb" );
     double btp_clock = WallClockTime( );
     if ( bases.size( ) > 0 )
     {    longlong genome_size = 0;
          if (USE_TRUTH)
          {    for ( int i = 0; i < genome.size( ); i++ )
                    genome_size += genome[i].size( );    }
          else genome_size = StringOfFile( data_dir + "/genome.size", 1 ).Int( );
          vecKmerPath spaths;
          ReadsToPathsCoreY( bases, K, genome_size, spaths );
          spaths.WriteAll( wrun_dir + "/reads.paths.k" + KS );
          vecKmerPath spaths_rc(spaths);
          for ( int i = 0; i < spaths.size( ); i++ )
               spaths_rc[i].Reverse( );
          spaths_rc.WriteAll( wrun_dir + "/reads.paths_rc.k" + KS );
          vec<tagged_rpint> spathsdb;
          CreateDatabase( spaths, spaths_rc, spathsdb );
          BinaryWrite2( wrun_dir + "/reads.pathsdb.k" + KS, spathsdb );    }
     else
     {    vecKmerPath spaths, spaths_rc;
          vec<tagged_rpint> spathsdb;
          spaths.WriteAll( wrun_dir + "/reads.paths.k" + KS );
          BinaryWrite2( wrun_dir + "/reads.pathsdb.k" + KS, spathsdb );    }
     cout << "\n============================================================"
          << "====================\n\n";
     cout << TimeSince(btp_clock) << " used converting bases to paths" << endl;
     KmerBaseBroker* kbb = new KmerBaseBroker( wrun_dir, K );
     NegativeGapValidator ngv(kbb);
     vecKmerPath paths( sub_dir + "/run/reads.paths.k" + KS );
     int count = 0;
     for ( int i = 0; i < hyperbases.isize( ); i++ )
     {    static vec<KmerPath> these_paths;
          these_paths.clear( );
          for ( int j = 0; j < hyperbases[i].EdgeObjectCount( ); j++ )
               these_paths.push_back( paths[count++] );
          HyperKmerPath h( K, hyperbases[i], these_paths );
          hypers.push_back(h);    }
     BinaryOverwrite( sub_dir + "/nhood.hypers", hypers );
     HyperKmerPath h( K, hypers );
     vecKmerPath unipathsx, uniq_unipathsx;
     for ( int i = 0; i < unipaths.size( ); i++ )
     {    unipathsx.push_back_reserve( paths[ edges0 + i ] );
          if ( predicted_copyno[i] == 1 && unipaths[i].KmerCount( ) >= 20 )
               uniq_unipathsx.push_back_reserve( paths[ edges0 + i ] );    }
     vec<tagged_rpint> unipathsxdb, uniqdb;
     CreateDatabase( unipathsx, unipathsxdb );
     CreateDatabase( uniq_unipathsx, uniqdb );

     // Merge HyperKmerPath.  Then reduce loops.  This should be inside 
     // InternalMerge but it didn't work when I put it there.  Should try again.

     if (FINAL_MERGE)
     {    double outer_merge_clock = WallClockTime( );
          if (OLD_INTERNAL_MERGE)
          {    Bool seed_unique = False;
               Bool seed_unique_weak = False;
               InternalMerge( h, ngv, MIN_OVERLAP_FINAL, MIN_PROPER_OVERLAP_FINAL, False );    }
          else
          {    GroupedInternalMerge( hypers, h, *kbb, 50, 20, ngv, 
                    MIN_OVERLAP_FINAL, MIN_PROPER_OVERLAP_FINAL, False, uniqdb,
                    SHORTEST_MERGE );   }
          cout << "\n" << TimeSince(outer_merge_clock) 
               << " used for final merge of paths" << endl;
          h.ReduceLoops( );
          h.CompressEdgeObjects( );
          h.RemoveDeadEdgeObjects( ); 
          h.RemoveEdgelessVertices( );    }

     BinaryOverwrite( sub_dir + "/hyper.initial", h );

     // Do global cleaning of graph.

     if (GLOBAL_CLEAN)
     {    GlobalClean( h, kbb, gkbb, sub_dir, reads, unipaths, ulocs, ulocs_indexr, 
               pairs, pairs_index, partner, SHOW_PAIR_ALIGNS, 
               MAX_SHORT_INSERT_SEP, verbose, uniqdb, unipathsx, unipathsxdb, 
               predicted_copyno, MIN_COMPONENT, readlocs, readlocs_index, 
               USE_TRUTH, data_dir, disambiguate_simple_loops_verbose,
	       pull_verbose, track_global_clean_changes, NEW_POORLY_COVERED );    }

     // Evaluate assembly and write it (after reordering using reference).

     BinaryOverwrite( sub_dir + "/hyper", h );
     Ofstream( dot, sub_dir + "/hyper.dot" );
     h.PrintSummaryDOT0w(dot);
     EvaluateAssembly( h, kbb, data_dir, wrun_dir, sub_dir, genome, DIPLOID, 
          USE_TRUTH, FILTER_ALIGNS, True );
     if ( USE_TRUTH ) {
       BinaryOverwrite( sub_dir + "/hyper.reordered", h );
       Ofstream( reordered_dot, sub_dir + "/hyper.reordered.dot" );
       h.PrintSummaryDOT0w(reordered_dot);    
     }
}
