/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef LOCALIZE_READS_ANNEX2_H
#define LOCALIZE_READS_ANNEX2_H

#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "system/ParsedArgs.h"
#include "ReadLocation.h"

void LocalizeReadsParallelLaunch( const String& PARALLEL_BATCHES,
     const vec<unipath_id_t>& seeds, const parsed_args& command, const String& data_dir,
     const String& run_dir, const String& sub_dir, const String& LSF_ARGS,
     const String& LSF_HOST, const int K, const Bool USE_TRUTH,
     const int MIN_OVERLAP_FINAL, const int MIN_PROPER_OVERLAP_FINAL,
     const Bool GLOBAL_CLEAN, const Bool TRACK_GLOBAL_CLEAN_CHANGES, 
     const int SHOW_PAIR_ALIGNS, const Bool FILTER_ALIGNS,
     const Bool FINAL_MERGE, const Bool BASIC_DEBUG, const Bool DIPLOID,
     const Bool DISAMBIGUATE_SIMPLE_LOOPS_VERBOSE, const Bool PULL_VERBOSE,
     const int MIN_COMPONENT, const int MAX_SHORT_INSERT_SEP,
     const String& unilocs_file, const String& wrun_dir,
     const Bool NEW_POORLY_COVERED = False );

void JustPlotLocalKmerFrequencies( const vec< pair<read_id_t,orient_t> >& use,      
     const vecbasevector& reads, const String& run_dir );

void ExtendClosures( vec<pp_pair> ppp, const vec<int>& L,
     vec< vec<pp_closure> >& ppclosures, const double dmult, 
     const int MAX_SHORT_INSERT_SEP );

#endif
