// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

#ifndef INTERNAL_MERGE_H
#define INTERNAL_MERGE_H

#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"
#include "paths/KmerPathInterval.h"
#include "paths/NegativeGapValidator.h"

// InternalMerge: glue internal aligning parts of a HyperKmerPath with length >=
// min_overlap, where min_overlap is measured in kmers.

void InternalMerge( HyperKmerPath& h, 
                    const NegativeGapValidator& ngv, int min_overlap, 
                    int min_proper_overlap, Bool SPECIAL );

void InternalMergeOnUnique( HyperKmerPath& h, 
                            const NegativeGapValidator& ngv, int min_overlap, 
                            int min_proper_overlap, Bool SPECIAL, 
                            const vec<tagged_rpint>& uniqdb,
                            Bool seed_unique_weak = False );

// GroupedInternalMerge: given a collection of HyperKmerPaths hin, first
// connect them using perfect matches between edges of size >=
// min_perfect_match_to_group.  Start with one of the HyperKmerPaths.  Find
// all HyperKmerPaths it is connected to, then iterate in total group_steps
// times to build a group.  Then take a HyperKmerPath that has not been placed
// in a group, and build a group around it (disjoint from any built so far).
// Keep going until all HyperKmerPaths are used up.  Merge each group, then
// merge the mergers to yield the final answer hout.  GroupedInternalMerge is
// generally faster than directly calling InternalMerge on the union of the
// HyperKmerPaths in hin.

void GroupedInternalMerge( const vec<HyperKmerPath>& hin,
     HyperKmerPath& hout, const KmerBaseBroker& kbb,
     const int min_perfect_match_to_group, const int group_steps, 
     const NegativeGapValidator& ngv, int min_overlap, int min_proper_overlap, 
     Bool SPECIAL, const vec<tagged_rpint>& uniqdb, const Bool SHORTEST_MERGE );

#endif
