/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// Hospital: try to pull apart globally overcollapsed edges in a HyperKmerPath h.
// See the Hospital.cc for more details on what it does.  This requires as
// input alignments of the reads to h.

#ifndef HOSPITAL_H
#define HOSPITAL_H

#include "Alignment.h"
#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"
#include "paths/KmerPath.h"

void Hospital( HyperKmerPath& h, const vecbasevector& reads,
     vec<alignment_plus>& Aligns, const KmerBaseBroker* kbb, 
     const vec<int>& partner, Bool verbose, const vec<tagged_rpint>& uniqdb );

#endif
