/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// A repository for some helper functions of GlobalClean that might
// be called from other places.

#ifndef GLOBAL_CLEAN_ANNEX
#define GLOBAL_CLEAN_ANNEX

#include "paths/KmerPath.h"
#include "paths/HyperKmerPath.h"

// For each edge, find the predicted copy number n of the unipath meeting
// it that has lowest predicted copy number.  It follows that if the
// unipaths are correct, and the predicted copy numbers are correct, than
// the edge cannot perfectly match the genome more than n times.  Note
// that the edge might have kmers that were created after the unipaths 
// were created, and these won't appear in the unipaths.
void MaxEdgeCopyNumber( const HyperKmerPath& h,
			const vec<tagged_rpint>& unipathsxdb,
			const vec<int>& predicted_copyno,
			vec<int>& edge_copyno );

#endif
