/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#include "paths/GlobalCleanAnnex.h"

void MaxEdgeCopyNumber( const HyperKmerPath& h,
			const vec<tagged_rpint>& unipathsxdb,
			const vec<int>& predicted_copyno,
			vec<int>& edge_copyno ) {
  edge_copyno.clear();
  edge_copyno.resize( h.EdgeObjectCount( ), 1000000000 );

  vec<longlong> places;
  for ( int i = 0; i < h.EdgeObjectCount( ); i++ ) {
    const KmerPath& e = h.EdgeObject(i);
    for ( int j = 0; j < e.NSegments( ); j++ ) {
      Contains( unipathsxdb, e.Segment(j), places );
      for ( int k = 0; k < places.isize( ); k++ ) {
	const tagged_rpint& t = unipathsxdb[ places[k] ];
	int pc = predicted_copyno[ t.PathId( ) ];
	edge_copyno[i] = Min( edge_copyno[i], pc );
      }
    }
  }
}

