/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef GLOBAL_CLEAN_H
#define GLOBAL_CLEAN_H

#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "ReadPairing.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"
#include "paths/SeqOnHyper.h"

void GlobalClean( HyperKmerPath& h, const KmerBaseBroker* kbb,
     const KmerBaseBroker* gkbb, const String& sub_dir, const vecbasevector& reads,
     const vecKmerPath& unipaths, const vec<read_location_short>& ulocs,
     const vecvec<int>& ulocs_indexr, const vec<read_pairing>& pairs,
     const vec<int>& pairs_index, const vec<int>& partner,
     const Bool SHOW_PAIR_ALIGNS, const int MAX_SHORT_INSERT_SEP, Bool verbose,
     const vec<tagged_rpint>& uniqdb, const vecKmerPath& unipathsx, 
     const vec<tagged_rpint>& unipathsxdb, const vec<int>& predicted_copyno, 
     const int MIN_COMPONENT, const vec<read_location>& readlocs, 
     const vec<int>& readlocs_index, const Bool USE_TRUTH, 
     const String& data_dir,
     const Bool disambiguate_simple_loops_verbose,
     const Bool pull_verbose, const Bool track_changes = False,
     const Bool NEW_POORLY_COVERED = False );

#endif
