// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

#ifndef FORCE_DEBUG
#define NDEBUG
#endif

// Finds the reads that subsume each read (if any) and records them.
// This is just a main() to call FindSubsumedReads and save the
// result to disk.

#include "MainTools.h"
#include "paths/KmerPathDatabase.h"
#include "paths/OrientedKmerPathId.h"
#include "paths/SubsumptionList.h"
#include "STLExtensions.h"
#include "TaskTimer.h"
#include "Histogram.h"

#include "paths/FindSubsumedReads.h"


int main( int argc, char *argv[] )
{
  RunTime( );
  
  BeginCommandArguments;
    CommandArgument_String(PRE);
    CommandArgument_String(DATA);
    CommandArgument_String(RUN);
    CommandArgument_UnsignedInt_OrDefault( K, 48 );
    CommandArgument_String_OrDefault( PATHSHQ, "pathshq" );
    CommandArgument_UnsignedInt_OrDefault( minNumKmers, 10 );
    CommandArgument_UnsignedInt_OrDefault( chunkSize, 100000 );
    CommandArgument_Bool_OrDefault( WRITE, True );
    CommandArgument_Bool_OrDefault( CONFIRM_WRITE, False );
  EndCommandArguments;

  String runDir = PRE + "/" + DATA + "/" + RUN;


  cout << Date() << ": Loading paths..." << endl;

  vecKmerPath pathsFw, pathsRc;
  pathsFw.ReadAll( runDir + "/reads." + PATHSHQ + ".k" + ToString(K) );
  pathsRc.ReadAll( runDir + "/reads." + PATHSHQ + "_rc.k" + ToString(K) );

  cout << Date() << ": Done." << endl;


  cout << Date() << ": Loading paths database..." << endl;

  vec<tagged_rpint> rawPathsDB;
  BREADX2( runDir + "/reads." + PATHSHQ + "db.k" + ToString(K), rawPathsDB );

  cout << Date() << ": Done." << endl;

  KmerPathDatabase pathsDb( &rawPathsDB );

  // Find subsumed reads.
  
  SubsumptionList theSubList( pathsFw.size() );

  longlong numSubsumed = FindSubsumedReads( theSubList, pathsFw, pathsRc, pathsDb, 
                                            minNumKmers, chunkSize, &cout );

  cout << Date() << ": Found " << numSubsumed << " subsumed reads." << endl;

  if ( WRITE )
  {
    theSubList.Write( runDir + "/reads." + PATHSHQ + "_sublist.k" + ToString(K) );

    if ( CONFIRM_WRITE )
    {
      SubsumptionList listOnDisk;
      listOnDisk.Read( runDir + "/reads." + PATHSHQ + "_sublist.k" + ToString(K) );
      
      ForceAssert( theSubList == listOnDisk );
    }
  }

  return 0;
}
