// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

#ifndef FINDSUBSUMEDREADS
#define FINDSUBSUMEDREADS

#include "paths/SubsumptionList.h"
#include "paths/KmerPathDatabase.h"

/// Finds the reads that subsume each read (if any) and records them.
/// The main() in FindSubsumptions calls this and saves the answers.

longlong FindSubsumedReads( SubsumptionList& theSubList,
                            const vecKmerPath& pathsFw,
                            const vecKmerPath& pathsRc,
                            const KmerPathDatabase& pathsDb,
                            const int minNumKmers = 10,
                            const longlong chunkSize = 100000,
			    ostream* out = NULL,
                            const int partition = 0 );

#endif
