/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef EVAL_UTILS_H
#define EVAL_UTILS_H

#include "Basevector.h"
#include "CoreTools.h"
#include "Feudal.h"
#include "math/HoInterval.h"
#include "lookup/LookAlign.h"
#include "paths/AlignHyperKmerPath.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"

// EvaluateAssembly.  Print out an evaluation of the assembly, using truth data if
// available.  Note that this will reorder the HyperKmerPath h.

void EvaluateAssembly( HyperKmerPath& h, const KmerBaseBroker* kbb,
     const String& data_dir, const String& wrun_dir, const String& sub_dir,
     const vecbasevector& genome, const Bool DIPLOID, const Bool USE_TRUTH,
     const Bool FILTER_ALIGNS, const Bool WRITE_ALIGNS, const Bool REORDER = True,
                       nbases_t MIN_LEN = 0,
		       String hkpFname = "",
		       String showTrustedSubdir = "/showTrusted",
		       HyperKmerPath *hInitial = NULL, const String& hkpFnameInitial = "",
		       Bool VERT = False );

void FilterAligns( const HyperKmerPath& h, vec<look_align>& aligns,
     vec< vec<int> >& aligns_index, vec<TrustedPath>& trusted_paths,
     const int MIN_LEN = 3000 );

#endif
