/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// Program: EvalHyper
//
// For simulated data, carry out the HyperKmerPath evaluation that 
// occurs at the tail end of LocalizeReads.  You can run this command with all the 
// LocalizeReads arguments.  It does not write any files (except standard output).

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif

#include "Basevector.h"
#include "Feudal.h"
#include "math/HoInterval.h"
#include "MainTools.h"
#include "lookup/LookAlign.h"
#include "paths/AlignHyperKmerPath.h"
#include "paths/EvalUtils.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"

int main( int argc, char *argv[] )
{
     RunTime( );

     BeginCommandArguments;
     CommandArgument_String(PRE);
     CommandArgument_String(DATA);
     CommandArgument_String(RUN);
     CommandArgument_String_OrDefault(INSTANCE, "");
     CommandArgument_String(SUBDIR);
     CommandArgument_String_OrDefault_Doc(TPDIR, "/showTrusted", "where to put the trusted path viewer");
     CommandArgument_String_OrDefault(HYPER, "hyper");
     CommandArgument_String_OrDefault(HYPER_INIT, "hyper.initial");
     CommandArgument_Bool_OrDefault(FILTER_ALIGNS, True);
     CommandArgument_Bool_OrDefault(DUMP_BASES, False);
     CommandArgument_Bool_OrDefault(DIPLOID, False);
     CommandArgument_Bool_OrDefault(REORDER, False);
     CommandArgument_Bool_OrDefault_Doc(SHOW2, False, "show two trusted path viewers?" );
     CommandArgument_Bool_OrDefault_Doc(VERT, False, "when SHOW, split vertically?" );
     CommandArgument_Int_OrDefault_Doc( MIN_LEN, 0, "min length of trusted paths to find" );
     EndCommandArgumentsAllowExtras;

     // Set up directories.

     SUBDIR += INSTANCE;
     String data_dir = PRE + "/" + DATA;
     String run_dir = PRE + "/" + DATA + "/" + RUN;
     String sub_dir = run_dir + "/ASSEMBLIES/" + SUBDIR;
     String wdata_dir = sub_dir;
     String wrun_dir = sub_dir + "/run";

     // Load data.

     vecbasevector genome( data_dir + "/genome.fastb" );
     String hkpFname = sub_dir + "/" + HYPER;
     HyperKmerPath h( hkpFname );
     int K = h.K( );
     KmerBaseBroker* kbb = new KmerBaseBroker( wrun_dir, K );

     // Evaluate assembly, reordering to follow reference.

     if ( !SHOW2 )
       EvaluateAssembly( h, kbb, data_dir, wrun_dir, sub_dir, genome, DIPLOID, 
			 True, FILTER_ALIGNS, False, REORDER, MIN_LEN,
			 hkpFname );
     else {
       String hkpFnameInitial = sub_dir + "/" + HYPER_INIT;
       HyperKmerPath hInitial( hkpFnameInitial );
       
       EvaluateAssembly( h, kbb, data_dir, wrun_dir, sub_dir, genome, DIPLOID, 
			 True, FILTER_ALIGNS, False, REORDER, MIN_LEN,
			 hkpFname, TPDIR, &hInitial, hkpFnameInitial, VERT );
     }

     // Dump bases.

     if (DUMP_BASES)
     {    for ( int i = 0; i < h.EdgeObjectCount( ); i++ )
               kbb->Seq( h.EdgeObject(i) ).Print( cout, BaseAlpha(i) );    }    }
