/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// Define two programs, one to find sequence bridges that close gaps, and another
// to close gaps.  These two programs need to be in sync.

#ifndef BRIDGE_GAPS_H
#define BRIDGE_GAPS_H

#include "Basevector.h"
#include "CoreTools.h"
#include "paths/HyperKmerPath.h"
#include "paths/KmerBaseBroker.h"
#include "paths/PairedPair.h"

void BridgeGaps( const vec<pp_pair>& ppp, const vec< vec<pp_closure> >& ppclosures,
     const HyperKmerPath& h, const KmerBaseBroker& kbb, vec<basevector>& bridges, 
     Bool verbose = False );

void SimpleExtendPairedPairs( const HyperKmerPath& h, const KmerBaseBroker& kbb,
     vec<pp_pair>& ppp, const vec<int>& L, const double dmult, 
     const vec<Bool>& remove = vec<Bool>( ), const Bool simple = False,
     const Bool verbose = False );

#endif
