// Copyright (c) 2000-2003 Whitehead Institute for Biomedical Research
// 


#ifndef SMITHWATBANDEDA
#define SMITHWATBANDEDA

#include "Alignment.h"
#include "Basevector.h"

float SmithWatBandedA( const basevector& S, const basevector& T, 
		       int offset, int bandwidth, align& a, int& errors, 
		       ostream* log = 0, int mis=2, int gap=3);

inline
float SmithWatBandedA( const basevector& S, const basevector& T, 
     int offset, int bandwidth, alignment& a, ostream *log = 0 )
{
  align temp; int errors;
  float result = SmithWatBandedA( S, T, offset, bandwidth, temp, errors, log );
  a.Set( temp, errors );
  return result;
}

#endif
