/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#include "math/Combinatorics.h"
#include "CoreTools.h"

double Choices(int n, int k)
{
  if (k<0)
    return 0.0;
  double prod = 1.0;
  for ( int j = 1; j <= k; ++j )
    prod *= double(n + 1 - j)/j;
  return prod;
}
  
double BinomialProb(double p, int n, int k)
{
  return Choices(n,k) * pow(p, k) * pow(1.0-p, n-k);
}


