/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef QUERY_LOOKUP_TABLE_CORE_H
#define QUERY_LOOKUP_TABLE_CORE_H

#include "CoreTools.h"
#include "TokenizeString.h"

void QueryLookupTableCore( int argc, char *argv[] );

inline void QueryLookupTableCore( const String& args )
{    vec<String> tokens;
     Tokenize( "QueryLookupTable " + args, tokens );
     int argc = tokens.size( );
     vec<char*> argv(argc);
     for ( int i = 0; i < argc; i++ )
          argv[i] = tokens[i].c_str_mutable( );
     QueryLookupTableCore( argc, &argv[0] );    }

#endif
