/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2006) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// Given a vecbasevector of reads, and the table T of strong (those thought to
// be genomic) k-mers, provisionally edit the reads as follows.
//
// If every kmer in a given read is strong (according to T) leave it alone.
// Otherwise, iterate through the bases of the read, mutating the current base
// to the other three possible nucleotides in turn, and determine whether every
// kmer in the mutated read is now strong (present in T).  If there is exactly
// one mutation where this is true, change that base to that value in the
// original read.  Otherwise, leave the read alone.
//
// In the case where you have multiple tables T[i] for a selection of
// values of K, perform the operation described above for each table T[i]
// (and its corresponding values of K), with the following changes:
//
// * Only leave a read alone if all its kmers at any value of K are strong.
//
// * Only edit the read if there is exactly one change such that the
// is strong condition is satisfied for the largest number of values of
// K.  For example, say you have three values of K, and only one of
// them is satisfied for the initial read.  There are two mutations
// that would satisfy two values of K, and one other that would
// satisfy all three.  The one that satisfies all three is chosen.  If
// there were none that satisfied all three, then neither of the other
// two would be chosen, and the read would be left alone.

#ifndef KMERFREQ_MAKEPROVISIONALCHANGES_H
#define KMERFREQ_MAKEPROVISIONALCHANGES_H

#include "Basevector.h"
#include "Qualvector.h"
#include "kmer_freq/KmerFrequencyTable.h"
#include "paths/BaseErrorProb.h"

void
MakeProvisionalChanges( vecbasevector& reads, vecqualvector& quals,
                        vec<KmerShortMap*>& tablePtrs,
                        const bool verbose = false,
			BaseErrorProbProfile probProfile = BaseErrorProbProfile(),
			const int max_errors = 1, const int max_entries = 0,
			const int error_prob_cutoff = 10,
			const bool peek_ahead = True);

// Convenience method when you want to call the above with just one value of K.
template <int K>
void
MakeProvisionalChanges( vecbasevector& reads, vecqualvector& quals,
                        const String& filename,
                        const bool verbose = false,
			const BaseErrorProbProfile& probProfile = BaseErrorProbProfile(),
			const int max_errors = 1, const int max_entries = 0,
			const int error_prob_cutoff = 10,
			const bool peek_ahead = True);


#endif
