/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2005) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

#ifndef FORCE_DEBUG
     #define NDEBUG
#endif

#include <ctype.h>
#include "CoreTools.h"
#include "ReadPairing.h"

void read_pairing::ChangeId( int old_id, int new_id )
{    if ( id1 == old_id ) id1 = new_id;
     if ( id2 == old_id ) id2 = new_id;    }

bool read_pairing::InvolvesId( int id ) 
{    return id1 >= 0 && id2 >= 0 && ( id1 == id || id2 == id );    }

int read_pairing::Partner( int id ) const
{    if ( id1 != id && id2 != id )
     {    PRINT3( id, id1, id2 );
          ForceAssert( id1 == id || id2 == id );    }
     if ( id1 == id ) return id2;
     else return id1;    }

void read_pairing::Kill( ) { id1 = -1; }

ostream& operator<<( ostream& o, const read_pairing& p )
{    return o << p.id1 << " " << p.sep << " " << p.id2 <<
          " " << p.sd << " " << int(p.t) << " " << p.weight;    }

istream& operator>>( istream& i, read_pairing& p )
{    int t;
     i >> p.id1 >> p.sep >> p.id2 >> p.sd >> t >> p.weight;
     p.t = (read_type) t;
     return i;    }

istream& operator>>( istream& i, vec<read_pairing>& v )
{    int length;
     i >> length;
     v.resize(length);
     for ( int j = 0; j < length; j++ )
          i >> v[j];
     return i;    }

void ReadBinaryPairs( istream &in, vec<read_pairing> &vecPairs )
{   int size;
    in >> size;
    vecPairs.resize( size );
    in.get();
    if ( vecPairs.nonempty( ) )
         in.read( (char *) &vecPairs[0], 
               sizeof( read_pairing ) * vecPairs.size() );    }

void ReadPairsFile( const String &strTextFilename, vec<read_pairing> &vecPairs )
{    String strBinaryFilename( strTextFilename  + "b" );
     if ( IsRegularFile( strBinaryFilename ) &&
          IsOlder( strTextFilename, strBinaryFilename ) )
     {    BinaryRead0( strBinaryFilename, vecPairs );    }
     else READX( strTextFilename, vecPairs );    }

void WritePairs( const String& run_dir, const vec<read_pairing>& pairs, int nreads,
     Bool extras_only )
{    if ( !extras_only )
     {    Ofstream( outp, run_dir + "/reads.pairto" );
          outp << pairs.size( ) << "\n";
          for ( int i = 0; i < pairs.isize( ); i++ ) 
               outp << pairs[i] << "\n";    }
     BinaryWrite0( run_dir + "/reads.pairtob", pairs );
     vec<int> pairs_index( nreads, -1 );
     for ( int i = 0; i < pairs.isize( ); i++ )
     {    ForceAssertLt( pairs[i].id1, nreads );
          ForceAssertLt( pairs[i].id2, nreads );
          pairs_index[ pairs[i].id1 ] = i;
          pairs_index[ pairs[i].id2 ] = i;    }
     BinaryWrite( run_dir + "/reads.pairto_index", pairs_index );    }

void ReadsToPairs( const String& dir, const vec<int>& ids,
     vec<read_pairing>& pairs )
{    pairs.resize( ids.size( ) );
     vec<int> ps;
     BinaryReadSubset( dir + "/reads.pairto_index", ids, ps );
     String npairs;
     {    Ifstream( in, dir + "/reads.pairtob" );
          in >> npairs;    }
     int head = npairs.size( ) + 1;
     int fd = OpenForRead( dir + "/reads.pairtob" );
     for ( int i = 0; i < ids.isize( ); i++ )
     {    if ( ps[i] < 0 ) pairs[i].Kill( );
          else
          {    lseek( fd, head + ps[i] * sizeof(read_pairing), SEEK_SET );
               read( fd, &pairs[i], sizeof(read_pairing) );    
               ForceAssert( ids[i] == pairs[i].id1 
                    || ids[i] == pairs[i].id2 );    }    }
     close(fd);    }
