// Copyright (c) 2005 Broad Institute/Massachusetts Institute of Technology

#include "ParseReadList.h"
#include "ParseSet.h"
#include "ReadLocation.h"

/// A ReadList is either:
/// (a) a list x of read ids in IntSet format, or
/// (b) dir:l, where dir is a SUBDIR and l is a list of contig ids in IntSet,
///     format, or
/// (c) x|dir:l, where x and dir:l are as in (a) and (b).

void ParseReadList( String descrip, String run_dir, vec<int>& answer )
{    if ( !descrip.Contains( ":" ) ) ParseIntSet( descrip, answer );
     else
     {    String before_colon = descrip.Before( ":" );
          String contig_descrip = descrip.After( ":" );
          String sub_dir;
          vec<int> answer0;
          if ( before_colon.Contains( "|" ) )
          {    int p;
               for ( p = before_colon.size( ) - 1; p >= 0; p-- )
                    if ( before_colon[p] == '|' ) break;
               ParseIntSet( before_colon.substr( 0, p ), answer0 );
               sub_dir = before_colon.substr( p, before_colon.size( ) - p );    }
          else sub_dir = before_colon;
          vec<int> contigs;
          ParseIntSet( contig_descrip, contigs );
          vec<read_location> locs;
          ReadLocs( run_dir + "/" + sub_dir + "/mergedcontigs_orig.locs",
               contigs, locs );
          answer = answer0;
          for ( int i = 0; i < locs.isize( ); i++ )
               answer.push_back( locs[i].ReadId( ) );
          UniqueSort(answer);    }    }
