// Copyright (c) 2000-2003 Whitehead Institute for Biomedical Research

// Class read_part is designed to read parts of a file.  This read is quite
// efficient, provided that the parts of the file are in order.

#ifndef FEUDAL_READ_PART
#define FEUDAL_READ_PART

#include "CoreTools.h"

class read_part {

     public:

     read_part( int fd )
     {    fd_ = fd;
          pagesize_ = getpagesize( );
          buf_.resize(pagesize_);
          where_ = &buf_[0];
          pagestart_ = -1;    }

     // Fetch nbytes bytes from the file, starting at "start", and place them at to.

     void Fetch( longlong start, longlong nbytes, char* to );

     private:
     
     int fd_;
     int pagesize_;
     longlong pagestart_;
     char* where_;
     vector<char> buf_;

};

#endif
