/////////////////////////////////////////////////////////////////////////////
//                   SOFTWARE COPYRIGHT NOTICE AGREEMENT                   //
//       This software and its documentation are copyright (2007) by the   //
//   Broad Institute/Massachusetts Institute of Technology.  All rights    //
//   are reserved.  This software is supplied without any warranty or      //
//   guaranteed support whatsoever. Neither the Broad Institute nor MIT    //
//   can be responsible for its use, misuse, or functionality.             //
/////////////////////////////////////////////////////////////////////////////

// Mimic: given a vecbasevector, generate a vecbitbector which has the same
// "dimensions", so that there is a bijective correspondence between bases in one
// and bits in the other.  (Also set the bitvector entries to False.)  Other similar 
// feudal conversions go here.

#ifndef FEUDAL_MIMIC_H
#define FEUDAL_MIMIC_H

#include "Basevector.h"
#include "Bitvector.h"
#include "CoreTools.h"
#include "Feudal.h"

void Mimic( const vecbasevector& in, vecbitvector& out );
void Mimic( const vecbasevector& in, vecvec<unsigned char>& out, 
     const unsigned char value = 0 );
void Mimic( const vecbasevector& in, vecvec<unsigned short>& out );
void Mimic( const vecbasevector& in, vecvec<int>& out );
void Mimic( const vecbasevector& in, vecvec<float>& out );

template<class vecvec1, class vecvec2, class number>
void Mimic(const vecvec1 & in, vecvec2 & out, number value) {
  out.resize(in.size());
  for (int i=0; i != in.size(); ++i) out[i].resize(in[i].size(),value);
}

template<class vecvec1, class vecvec2>
void Mimic(const vecvec1 & in, vecvec2 & out) {
  out.resize(in.size());
  for (int i=0; i != in.size(); ++i) out[i].resize(in[i].size(), 0);
}

#endif
